﻿//////////////////////////////////////////////
// GroupBox.h
//
//////////////////////////////////////////////

/// Defines / Macros -------------------------

#pragma once

/// Forward decl -----------------------------

namespace nkWinUi
{
	class Static ;
	class System ;
}

/// Includes ---------------------------------

// nkWinUi
#include "Component.h"

#include "../Dll/DllDefines.h"

// nkMemory
#include <NilkinsMemory/Pointers/UniquePtr.h>

/// Class ------------------------------------
	
namespace nkWinUi
{
	class DLL_WINUI_EXPORT GroupBox : public Component
	{		
		public :
		
			// Constructor, destructor
			GroupBox (System* system) noexcept ;
			virtual ~GroupBox () ;

			// Implementations
			virtual float getLayoutAllowedWidth () const override ;
			virtual float getLayoutAllowedHeight () const override ;
			virtual float getLayoutAllowedOffsetX () const override ;
			virtual float getLayoutAllowedOffsetY () const override ;

		public :

			// Statics
			static nkMemory::UniquePtr<GroupBox> create (System* system = nullptr) ;

		protected :
		
			// Attributes			
			float _textWidth ;
			float _textHeight ;
	} ;
}